/*
    6-19-2007
    Copyright Spark Fun Electronics 2007
    Nathan Seidle
    nathan at sparkfun.com
    
	Keyboard PS/2 Interpreter
	
	http://www.computer-engineering.org/ps2protocol/
	
	Original Fuses : avrdude -p atmega8 -P lpt1 -c stk200 -U lfuse:w:0xE1:m -U hfuse:w:0xD9:m
	16MHz Fuses : avrdude -p atmega8 -P lpt1 -c stk200 -U lfuse:w:0xEE:m -U hfuse:w:0xC9:m
*/

#include <stdio.h>
#include <avr/io.h>

#define FOSC 1000000 //1MHz internal osc
#define BAUD 4800
#define MYUBRR (((((FOSC * 10) / (16L * BAUD)) + 5) / 10) - 1)

#define sbi(var, mask)   ((var) |= (uint8_t)(1 << mask))
#define cbi(var, mask)   ((var) &= (uint8_t)~(1 << mask))

#define STAT_LED	0 //PORTB

//Define functions
//======================
void ioinit(void);      //Initializes IO
void delay_ms(uint16_t x); //General purpose delay
void delay_us(uint8_t x);

#include "nordic-nRF24L01.c"

static int uart_putchar(char c, FILE *stream);
static FILE mystdout = FDEV_SETUP_STREAM(uart_putchar, NULL, _FDEV_SETUP_WRITE);
//======================

int main (void)
{
    uint8_t incoming;
	uint8_t i = 0;

	ioinit();

	printf("Nordic Serial\n\n");

	//configure_transmitter();
	configure_receiver();
	
	while(1)
	{
		incoming = rx_send_byte(0xFF); //Get status register
		//printf("rx status=0x%02x\n", incoming);

		if (incoming & 0x40)
		{
			//We have data!
			receive_data();
			//printf("d0=0x%x\n", data_array[0]);

			switch(data_array[0])
			{
				case 0x17: printf("Left button"); break;
				case 0x1E: printf("Bottom button"); break;
				case 0x1B: printf("Right button"); break;
				case 0x1D: printf("Top button"); break;
				case 0x0F: printf("Center button"); break;
				default: printf("No button!"); break;
			}

			printf(" Presses=%d\n", data_array[2]);
		}

		//incoming = tx_send_byte(0xFF); //Get status register
		//printf(" tx status=0x%02x", incoming);

		delay_ms(10);
	}
	
    return(0);
}

void ioinit (void)
{
	//1 = Output, 0 = Input
	DDRB = 0b00000001; //(STAT on PB0)
	DDRC = 0b11111000; //(LIGHT on PC0) (SOIL on PC1) (H-DAT on PC4) (H-SCK on PC5)
    DDRD = 0b11111110; // (RXD on PD0)

    //USART Baud rate: 9600
    UBRR0H = MYUBRR >> 8;
    UBRR0L = MYUBRR;
    UCSR0B = (1<<RXEN0)|(1<<TXEN0);

    stdout = &mystdout; //Required for printf init

    //Init timer 2
	//1,000,000 / 1 = 1,000,000
    TCCR2B = (1<<CS20); //Set Prescaler to 1. CS20=1
	
	init_nRF_pins();
}

static int uart_putchar(char c, FILE *stream)
{
    if (c == '\n') uart_putchar('\r', stream);
  
    loop_until_bit_is_set(UCSR0A, UDRE0);
    UDR0 = c;
    
    return 0;
}

//General short delays
void delay_ms(uint16_t x)
{
	for (; x > 0 ; x--)
	{
		delay_us(250);
		delay_us(250);
		delay_us(250);
		delay_us(250);
	}
}

//General short delays
void delay_us(uint8_t x)
{
	TIFR2 = 0x01; //Clear any interrupt flags on Timer2
	
    TCNT2 = 256 - x; //256 - 125 = 131 : Preload timer 2 for x clicks. Should be 1us per click

	while( (TIFR2 & (1<<TOV2)) == 0);
}
